//
//  GHLapData.h
//  Garmin Health
//
//  Created by Echeandia, Augie on 11/1/16.
//  Copyright © 2016 Garmin International, Inc. or its affiliates. All rights reserved.
//

#import <Foundation/Foundation.h>

@class GHRecordData;

/**
 *  The GHLapData class provides detailed information about a lap within a User initiated activity.
 */
@interface GHLapData : NSObject <NSCoding>

/** Latitude in degrees for the start of the lap. Can be null. */
@property (nullable, nonatomic, readonly) NSNumber *startLatitude;

/** Longitude in degrees for the start of the lap. Can be null. */
@property (nullable, nonatomic, readonly) NSNumber *startLongitude;

/** Latitude in degrees for the end of the lap. Can be null. */
@property (nullable, nonatomic, readonly) NSNumber *endLatitude;

/** Longitude in degrees for the end of the lap. Can be null. */
@property (nullable, nonatomic, readonly) NSNumber *endLongitude;

/** Starting time of the lap. Can be null. */
@property (nullable, nonatomic, readonly) NSDate *startTime;

/** Elapsed time in seconds. Can be null. */
@property (nullable, nonatomic, readonly) NSNumber *elapsedTime;

/** Distance covered in meters. Can be null. */
@property (nullable, nonatomic, readonly) NSNumber *distance;

/** Calories burned. Can be null. */
@property (nullable, nonatomic, readonly) NSNumber *calories;

/** Average speed in meters per second (m/s). Can be null. */
@property (nullable, nonatomic, readonly) NSNumber *averageSpeed;

/** Maximum speed in meters per second (m/s). Can be null. */
@property (nullable, nonatomic, readonly) NSNumber *maximumSpeed;

/** Average heart rate in beats per minute (BPM). Can be null*/
@property (nullable, nonatomic, readonly) NSNumber *averageHeartRate;

/** Maximum heart rate in beats per minute (BPM) Can be null*/
@property (nullable, nonatomic, readonly) NSNumber *maximumHeartRate;

/** Average cadence in revolutions per minute (RPM). Can be null. */
@property (nullable, nonatomic, readonly) NSNumber *averageCadence;

/** Maximum cadence in revolutions per minute (RPM). Can be null. */
@property (nullable, nonatomic, readonly) NSNumber *maximumCadence;

/** Array of records for the lap. Refer to GHRecordData for details regarding this data. */
@property (nonnull, nonatomic, readonly) NSArray<GHRecordData *> *recordsArray;


@end
